/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.util.Clipboard;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.DataLogParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogNetworkNodeBlock;
import DE.siemens.ad.logo.model.block.DataLogBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.NetworkNodeBlock;
import DE.siemens.ad.logo.model.block.SAnalogOutputBlock;
import DE.siemens.ad.logo.model.block.SOutputBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.action.SubstituteBlockAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.MultiHeadConstraint;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PasteAction
extends UndoableAction {
    private static final long serialVersionUID = 1L;
    protected ArrayList fBlockFigures;
    public Point pastePosition;
    public HashSet insertedConstraints;
    protected Vector fClipboardFigures = null;
    protected ProgramException fMessages;

    public PasteAction() {
        this.putValue("Name", "Einf\u00fcgen");
        this.putValue("textKey", "edit.paste");
        this.putValue("SmallIcon", Global.getIcon("Paste.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.paste", "paste"));
        this.disabledContextVector = new Vector(2);
        this.disabledContextVector.add(SimulationTool.class);
        this.disabledContextVector.add(OnlineTestTool.class);
    }

    protected void addError(String text) {
        if (this.fMessages == null) {
            this.fMessages = new ProgramException();
        }
        this.fMessages.setUser(text);
    }

    protected void addWarning(String text) {
        if (this.fMessages == null) {
            this.fMessages = new ProgramException();
        }
        this.fMessages.setLog(text);
    }

    protected Rectangle bounds(Enumeration k) {
        if (!k.hasMoreElements()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = ((Figure)k.nextElement()).displayBox();
        while (k.hasMoreElements()) {
            r.add(((Figure)k.nextElement()).displayBox());
        }
        return r;
    }

    public void deleteMessages() {
        if (this.fMessages != null) {
            this.fMessages = null;
        }
    }

    public void displayMessages() {
        if (this.fMessages != null) {
            this.fMessages.display(((LogoComfort)this.getOwner()).getApplicationSurface().getWindow(), null);
        }
    }

    public boolean doIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        this.insertFigures(this.insertedConstraints);
        this.moveToPastePosition(this.insertedConstraints);
        view.clearSelection();
        this.selectFigures(this.insertedConstraints);
        super.doIt();
        this.pastePosition = null;
        for (Object o : this.insertedConstraints) {
            Figure figure = ((FigureConstraint)o).getFigure();
            if (!(figure instanceof UDFBlockFigure)) continue;
            UDFBlock udfBlock = (UDFBlock)((UDFBlockFigure)figure).getBlock();
            udfBlock.setState(UDFFactory.instance().getUDFBlockState(udfBlock.getGuid()));
        }
        return true;
    }

    public Block[] getBlockArray() {
        ArrayList figures = this.getBlockFigures();
        int nrOfBlocks = figures.size();
        Block[] blocks = new Block[nrOfBlocks];
        for (int i = 0; i < nrOfBlocks; ++i) {
            blocks[i] = ((BlockFigure)figures.get(i)).getBlock();
        }
        return blocks;
    }

    public BlockFigure getBlockFigure(Block block) {
        ArrayList figures = this.getBlockFigures();
        int figureSize = figures.size();
        for (int j = 0; j < figureSize; ++j) {
            BlockFigure figure = (BlockFigure)figures.get(j);
            if (figure.getBlock() != block) continue;
            return figure;
        }
        return null;
    }

    public ArrayList getBlockFigures() {
        if (this.fBlockFigures == null) {
            this.fBlockFigures = new ArrayList();
            for (Figure f : this.fClipboardFigures) {
                if (!(f instanceof BlockFigure)) continue;
                this.fBlockFigures.add(f);
            }
        }
        return this.fBlockFigures;
    }

    public ArrayList getBlockFigures(ArrayList blockList) {
        ArrayList<BlockFigure> figures = new ArrayList<BlockFigure>();
        int size = blockList.size();
        for (int i = 0; i < size; ++i) {
            BlockFigure blockFigure = this.getBlockFigure((Block)blockList.get(i));
            if (blockFigure == null) continue;
            figures.add(blockFigure);
        }
        return figures;
    }

    public HashSet getConstraintsForFigures(Collection figures) {
        HashSet<FigureConstraint> constraints = new HashSet<FigureConstraint>(30);
        for (Figure figure : figures) {
            constraints.add(figure.getConstraint().getTopLevelConstraint());
            if (!(figure instanceof BlockFigure) || ((BlockFigure)figure).getCommentFigure() == null) continue;
            constraints.add(((BlockFigure)figure).getCommentFigure().getConstraint());
        }
        return constraints;
    }

    protected Vector getFiguresForConstraints(HashSet constraints) {
        Iterator i = constraints.iterator();
        Vector<Figure> figures = new Vector<Figure>();
        while (i.hasNext()) {
            FigureConstraint fc = (FigureConstraint)i.next();
            if (fc instanceof MultiHeadConstraint) {
                ((MultiHeadConstraint)fc).getFigures(figures);
                continue;
            }
            figures.add(fc.getFigure());
        }
        return figures;
    }

    public void insertFigures(HashSet constraints) {
        Drawing drawing = ((LogoComfort)this.getOwner()).drawing();
        Iterator i = constraints.iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = (FigureConstraint)i.next();
            constraint.insert(drawing);
        }
    }

    public void moveToPastePosition(HashSet constraints) {
        boolean viewToSmall;
        Rectangle bounds = this.bounds(this.getFiguresForConstraints(constraints).elements());
        LogoDrawingView view = (LogoDrawingView)((LogoComfort)this.getOwner()).view();
        LogoDrawing logoDrawing = (LogoDrawing)view.drawing();
        int moveLeft = 0;
        int moveUp = 0;
        if (this.pastePosition == null) {
            this.pastePosition = view.lastClick();
            if (view.getConstrainer() instanceof LogoGridConstrainer) {
                this.pastePosition = ((LogoGridConstrainer)view.getConstrainer()).constrainPoint(this.pastePosition);
            }
        }
        if (logoDrawing instanceof LogoDrawingUDF) {
            Rectangle udfEditArea = ((LogoDrawingUDF)logoDrawing).getEditUDFFigure().getEditArea();
            if (this.pastePosition.x + bounds.width > udfEditArea.x + udfEditArea.width) {
                moveLeft = this.pastePosition.x + bounds.width - (udfEditArea.x + udfEditArea.width);
            } else if (this.pastePosition.x < udfEditArea.x) {
                moveLeft = this.pastePosition.x - udfEditArea.x;
            }
            if (this.pastePosition.y + bounds.height > udfEditArea.y + udfEditArea.height) {
                moveUp = this.pastePosition.y + bounds.height - (udfEditArea.y + udfEditArea.height);
            } else if (this.pastePosition.y < udfEditArea.y) {
                moveUp = this.pastePosition.y - udfEditArea.y;
            }
        } else {
            Dimension viewDimension = logoDrawing.getViewSize100();
            if (this.pastePosition.x + bounds.width > viewDimension.width) {
                moveLeft = this.pastePosition.x + bounds.width - viewDimension.width;
            }
            if (this.pastePosition.y + bounds.height > viewDimension.height) {
                moveUp = this.pastePosition.y + bounds.height - viewDimension.height;
            }
        }
        boolean bl = viewToSmall = moveLeft > this.pastePosition.x || moveUp > this.pastePosition.y;
        if (viewToSmall) {
            Dimension pageSize = logoDrawing.getPageDimension();
            Dimension minSize = logoDrawing.getMinimumSize();
            Object[] pageCount = new Object[]{new Integer(minSize.width / pageSize.width + 1), new Integer(minSize.height / pageSize.height + 1)};
            JOptionPane.showMessageDialog(view.getViewComponent(), Language.getString("error.dialog.tooLessPages", "Too less pages to see whole drawing. You need at least % horizontal and % vertical.", pageCount), Language.getStringNoTilde("edit.paste", "Paste"), 1);
        }
        moveUp = Math.min(moveUp, this.pastePosition.y);
        moveLeft = Math.min(moveLeft, this.pastePosition.x);
        Dimension moveVektor = new Dimension(this.pastePosition.x - bounds.x - moveLeft, this.pastePosition.y - bounds.y - moveUp);
        if (!this.fBlockFigures.isEmpty()) {
            Figure firstFigure = (Figure)this.fBlockFigures.get(0);
            firstFigure.getConstraint().doMove(moveVektor);
            Dimension correction = view.getSnapVector(firstFigure);
            firstFigure.getConstraint().doMove(new Dimension(-moveVektor.width, -moveVektor.height));
            moveVektor.width += correction.width;
            moveVektor.height += correction.height;
        }
        Iterator i = this.getFiguresForConstraints(constraints).iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = ((Figure)i.next()).getConstraint();
            if (constraint instanceof ConnectionLineConstraint) continue;
            constraint.doMove(moveVektor);
        }
        i = this.getFiguresForConstraints(constraints).iterator();
        while (i.hasNext()) {
            constraint = ((Figure)i.next()).getConstraint();
            if (!(constraint instanceof ConnectionLineConstraint)) continue;
            constraint.doMove(moveVektor);
        }
    }

    public Vector getClipboardFigures(FigureSelection figureSelection) {
        return (Vector)figureSelection.getData("CH.ifa.draw.Figures");
    }

    public boolean prepareAction() {
        Block[] blockArray;
        List unavailableBlocks;
        this.deleteMessages();
        Log.printStartSequence("msg.pasteAction", "msg.pasteAction");
        FigureSelection figureSelection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (figureSelection == null) {
            return false;
        }
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        WiringDiagram wd = ((LogoDrawing)view.drawing()).getWiringDiagram();
        this.fClipboardFigures = this.getClipboardFigures(figureSelection);
        this.fBlockFigures = null;
        if (this.pastePosition == null) {
            this.pastePosition = view.lastClick();
        }
        if (view.getConstrainer() instanceof LogoGridConstrainer) {
            this.pastePosition = ((LogoGridConstrainer)view.getConstrainer()).constrainPoint(this.pastePosition);
        }
        StringBuffer sb = new StringBuffer();
        Vector fCopiedClipboardFigures = (Vector)this.fClipboardFigures.clone();
        boolean hasMiniblock = false;
        for (Object o : fCopiedClipboardFigures) {
            if (o instanceof EditUDFFigure) {
                sb.append("\n - UDF edit framework");
                this.fClipboardFigures.remove(o);
                continue;
            }
            if (!(o instanceof EditUDFFigure.MiniBlockFigure)) continue;
            if (!hasMiniblock) {
                sb.append("\n - UDF connector figure");
            }
            hasMiniblock = true;
            this.fClipboardFigures.remove(o);
        }
        if (sb.length() > 0) {
            String messageHeader = Language.getString("msg.paste.pastnotallowed", "The following figures are skipped:");
            String infoTitle = Language.getStringNoTilde("edit.paste", "Paste");
            messageHeader = messageHeader + sb;
            JOptionPane.showMessageDialog(this.getOwner().getWindow(), messageHeader, infoTitle, 1);
        }
        if (!(unavailableBlocks = this.getUnavailableBlocks(blockArray = this.getBlockArray(), wd)).isEmpty()) {
            this.NotifyBlockUnavailable(unavailableBlocks);
            this.pastePosition = null;
            return false;
        }
        this.connectBlocksOnModelSide(this.getConstraintsForFigures(this.fClipboardFigures), blockArray);
        HashMap dict = new HashMap();
        for (int i = 0; i < blockArray.length; ++i) {
            blockArray[i].deleteReferences(dict);
            if (blockArray[i] instanceof DataLogBlock) {
                DataLogParameter dataLogParam = (DataLogParameter)blockArray[i].getParameter();
                ParameterItemList paraList = dataLogParam.getParameterItemList();
                paraList.clear();
                continue;
            }
            if (blockArray[i] instanceof NetworkNodeBlock || blockArray[i] instanceof AnalogNetworkNodeBlock) {
                NetworkNodeParameter nodeParameter = (NetworkNodeParameter)blockArray[i].getParameter();
                if (!nodeParameter.isForSlave()) continue;
                nodeParameter.setAddress(null);
                nodeParameter.setConfiguredBlockType(0);
                nodeParameter.setConfiguredBlockNumber(0);
                continue;
            }
            if (!(blockArray[i] instanceof SOutputBlock) && !(blockArray[i] instanceof SAnalogOutputBlock)) continue;
            SOutputParameter parameter = (SOutputParameter)blockArray[i].getParameter();
            parameter.setAddress(null);
            parameter.setConfiguredBlockNumber(0);
        }
        boolean insertError = wd.insert(blockArray, dict);
        if (dict.get("err") != null) {
            this.notifyInsertError(dict);
            this.pastePosition = null;
            return false;
        }
        ArrayList list = (ArrayList)dict.get("propChanged");
        if (list != null) {
            this.updateBlockProperty(this.getBlockFigures(list), (ArrayList)dict.get("propChangedString"));
        }
        for (int i = 0; i < blockArray.length; ++i) {
            if (blockArray[i].getParameter() == null) continue;
            blockArray[i].getParameter().fireParameterSetEvent();
        }
        list = (ArrayList)dict.get("substitute");
        if (list != null) {
            this.replaceFigures(list);
        }
        HashSet constraints = this.getConstraintsForFigures(this.fClipboardFigures);
        this.fBlockFigures = null;
        blockArray = this.getBlockArray();
        this.insertedConstraints = this.removeOpenConnections(constraints, blockArray);
        if (constraints.size() != this.insertedConstraints.size()) {
            this.addWarning(Language.getString("msg.notComplete", "Insert not complete.Open Connections!"));
        }
        this.displayMessages();
        return true;
    }

    private void NotifyBlockUnavailable(List unavailableBlocks) {
        String messageHeader = Language.getString("msg.paste.blockNotAvailable", "Could not insert.\nThe following blocks are not available in the\ncurrent hardware or programming language:");
        StringBuffer message = new StringBuffer(messageHeader);
        message.append("\n");
        Iterator i = unavailableBlocks.iterator();
        while (i.hasNext()) {
            message.append("\n- ");
            message.append(((Block)i.next()).getLocalizedName(true));
        }
        String infoTitle = Language.getStringNoTilde("edit.paste", "Paste");
        JOptionPane.showMessageDialog(this.getOwner().getWindow(), message.toString(), infoTitle, 1);
    }

    private void notifyInsertError(HashMap dict) {
        String error = (String)dict.get("err");
        if (error.equals("noResource")) {
            this.addError(Language.getString("msg.noresources", "There are not enough resources to insert the blocks"));
        } else {
            this.addError(Language.getString(error, error));
        }
        ArrayList errorList = (ArrayList)dict.get("errDescription");
        if (errorList != null) {
            for (ErrorInfo entry : errorList) {
                ArrayList list = entry.getAdditionalInfo();
                String leading = "";
                if (list.size() > 0) {
                    if (list.get(0) instanceof Hardware) {
                        leading = ((Hardware)list.get(0)).getLocalizedName(true);
                    } else {
                        System.err.println("wiringDiagram.isBlockAvailable(Block,Hardware): Unknown additional Parameter");
                    }
                }
                this.addError(leading + ":\t" + entry.getSource().getLocalizedName(true) + "\t" + entry.getMessage());
            }
        }
        this.displayMessages();
    }

    public HashSet removeOpenConnections(HashSet constraints, Block[] blockArray) {
        Vector<Block> blocks = new Vector<Block>();
        for (int i = 0; i < blockArray.length; ++i) {
            blocks.add(blockArray[i]);
        }
        HashSet<FigureConstraint> constraintsWithoutOpenConnectoins = new HashSet<FigureConstraint>(30);
        Iterator i = constraints.iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = (FigureConstraint)i.next();
            if (constraint instanceof ConnectionConstraint) {
                ConnectionConstraint connectionConstraint = (ConnectionConstraint)((Object)constraint);
                Block inConnectorOwner = connectionConstraint.getInBlockConnector().getOwner();
                Block outConnectorOwner = connectionConstraint.getOutBlockConnector().getOwner();
                if (connectionConstraint.getInBlockConnector().getOwner() instanceof DeputyBlock) {
                    inConnectorOwner = ((DeputyBlock)connectionConstraint.getInBlockConnector().getOwner()).getParent();
                }
                if (connectionConstraint.getOutBlockConnector().getOwner() instanceof DeputyBlock) {
                    outConnectorOwner = ((DeputyBlock)connectionConstraint.getOutBlockConnector().getOwner()).getParent();
                }
                if (connectionConstraint.getInBlockConnector() != null && connectionConstraint.getOutBlockConnector() != null && blocks.contains(inConnectorOwner) && blocks.contains(outConnectorOwner)) {
                    constraintsWithoutOpenConnectoins.add(constraint);
                    connectionConstraint.connectInModel();
                    continue;
                }
                constraint.delete();
                continue;
            }
            constraintsWithoutOpenConnectoins.add(constraint);
        }
        return constraintsWithoutOpenConnectoins;
    }

    private void connectBlocksOnModelSide(HashSet constraints, Block[] blockArray) {
        Vector<Block> blocks = new Vector<Block>();
        for (int i = 0; i < blockArray.length; ++i) {
            blocks.add(blockArray[i]);
        }
        Iterator i = constraints.iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = (FigureConstraint)i.next();
            if (!(constraint instanceof ConnectionConstraint)) continue;
            ConnectionConstraint connectionConstraint = (ConnectionConstraint)((Object)constraint);
            InBlockConnector inConnector = connectionConstraint.getInBlockConnector();
            OutBlockConnector outConnector = connectionConstraint.getOutBlockConnector();
            Block inConnectorOwner = null;
            Block outConnectorOwner = null;
            if (inConnector != null) {
                inConnectorOwner = inConnector.getOwner() instanceof DeputyBlock ? ((DeputyBlock)inConnector.getOwner()).getParent() : inConnector.getOwner();
            }
            if (outConnector != null) {
                outConnectorOwner = outConnector.getOwner() instanceof DeputyBlock ? ((DeputyBlock)outConnector.getOwner()).getParent() : outConnector.getOwner();
            }
            if (inConnectorOwner == null || outConnectorOwner == null || !blocks.contains(inConnector.getOwner()) || !blocks.contains(outConnector.getOwner())) continue;
            connectionConstraint.connectInModel();
        }
    }

    protected boolean replaceFigures(AbstractList list) {
        SubstituteBlockAction substitueBlockAction = new SubstituteBlockAction();
        LogoDrawingView view = this.getDrawingView();
        substitueBlockAction.setOwner((Editor)((Object)view.editor()));
        Iterator itr = list.iterator();
        this.addWarning(Language.getString("msg.blockSubstitute", "Blocks substituted"));
        try {
            while (itr.hasNext()) {
                Block oldBlock = (Block)itr.next();
                Block newBlock = (Block)itr.next();
                StringBuffer buffer = new StringBuffer();
                buffer.append(oldBlock.getLocalizedName(true));
                buffer.append("\t-->\t");
                buffer.append(newBlock.getLocalizedName(true));
                this.addWarning(buffer.toString());
                BlockFigure oldBlockFigure = this.getBlockFigure(oldBlock);
                substitueBlockAction.setOldBlockFigure(oldBlockFigure);
                substitueBlockAction.setNewBlock(newBlock);
                substitueBlockAction.prepareAction();
                substitueBlockAction.doIt();
                this.fClipboardFigures.remove(oldBlockFigure);
                this.fClipboardFigures.add(substitueBlockAction.getNewBlockFigure());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void selectFigures(HashSet insertedConstraints) {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector figures = this.getFiguresForConstraints(insertedConstraints);
        Iterator i = figures.iterator();
        while (i.hasNext()) {
            view.addToSelection((Figure)i.next());
        }
    }

    public void undoIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        view.clearSelection();
        Iterator i = this.insertedConstraints.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).delete();
        }
        view.checkDamage();
    }

    public void updateBlockProperty(ArrayList blockList, ArrayList changes) {
        BlockFigure blockFigure = null;
        Block block = null;
        this.addWarning(Language.getString("msg.blockPropertyChanged", "Blockproperty changed:"));
        int size = blockList.size();
        for (int i = 0; i < size; ++i) {
            blockFigure = (BlockFigure)blockList.get(i);
            block = blockFigure.getBlock();
            try {
                this.addWarning(block.getLocalizedName(true) + ": " + (String)changes.get(i));
            }
            catch (Exception e) {
                System.out.println("Zu wenig Beschreibungen");
                e.printStackTrace();
            }
            blockFigure.getBlockTextFigure().setText(block.getNumberString());
        }
    }

    protected List getUnavailableBlocks(Block[] blocks, WiringDiagram wiringDiagram) {
        ArrayList<Block> notAvailableBlocks = new ArrayList<Block>();
        ProgrammingLanguage programmingLanguage = wiringDiagram.getProgrammingLanguage();
        Hardware hardware = wiringDiagram.getHardware();
        for (int i = 0; i < blocks.length; ++i) {
            if (!programmingLanguage.isBlockAvailable(blocks[i], hardware)) {
                notAvailableBlocks.add(blocks[i]);
                continue;
            }
            if (!(wiringDiagram instanceof WiringDiagramUDF) || !((WiringDiagramUDF)wiringDiagram).getUDFBlock().isUDFSelf(blocks[i]) && (blocks[i].getNumberType() != 10 || blocks[i].getNumber() != 8 && blocks[i].getNumber() != 25 && blocks[i].getNumber() != 26 && blocks[i].getNumber() != 27)) continue;
            notAvailableBlocks.add(blocks[i]);
        }
        return notAvailableBlocks;
    }

    public void setPastePosition(Point p) {
        this.pastePosition = p;
    }
}

